/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.simdebug;

import com.ibm.hwmca.base.simdebug.ItemDescUtils;
import com.ibm.hwmca.base.simdebug.SysInfoErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;

public class SysInfoManagerBean
extends PanelBean
implements TaskActionListener,
SysInfoErrorIds,
TaskNotifyCompleteListener {
    private static final String TRACE_MASKT = "XSIMBEAT";
    private static final String TRACE_MASKF = "XSIMBEAF";
    private static final String TRACE_MASKD = "XSIMBEAD";
    private static final String APP_NAME = "SystemInfoManager";
    private static final String MENU = "SysInfoChoice";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(22, "SystemInfoManager");
    private String m_sSysInfoChoice;
    private transient ValueDescriptor[] m_cdSysInfoChoice;
    private String m_sValueEdit;
    private transient String m_sValueEditSave;
    private transient String m_sKeyEdit;
    private transient ActionDescriptor[] m_adMenuChoice;
    private String[] simFields = null;

    public SysInfoManagerBean(String[] data) {
        this.simFields = data;
        Trace.trace(TRACE_MASKT, "<> SysInfoManagerBean.constructor()");
    }

    public ValueDescriptor[] getSysInfoChoiceList() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getSysInfoChoiceList()");
        return this.m_cdSysInfoChoice;
    }

    public String getSysInfoChoice() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getSysInfoChoice()");
        return this.m_sSysInfoChoice;
    }

    public void setSysInfoChoice(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setSysInfoChoice(String s)");
        this.m_sSysInfoChoice = s;
    }

    public String getValueEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getValueEdit()");
        return this.m_sValueEdit;
    }

    public void setValueEdit(String s) {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setValueEdit()");
        this.m_sValueEditSave = this.m_sValueEdit;
        this.m_sValueEdit = s;
    }

    public void resetValueEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.resetValueEdit()");
        this.m_sValueEdit = this.m_sValueEditSave;
    }

    public String getKeyEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getKeyEdit()");
        return this.m_sKeyEdit.toUpperCase();
    }

    public void setKeyEdit(String s) {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setKeyEdit(String s)");
        this.m_sKeyEdit = s;
    }

    public ActionDescriptor[] getMenuChoiceList() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getMenuChoiceList()");
        return this.m_adMenuChoice;
    }

    public Capabilities getCapabilities() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getCapabilities()");
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> SysInfoManagerBean.load()");
        try {
            this.m_sSysInfoChoice = "";
            this.m_sValueEdit = "";
            this.m_sKeyEdit = "";
            if (this.simFields != null) {
                this.m_sSysInfoChoice = this.simFields[0];
                this.m_cdSysInfoChoice = new ValueDescriptor[this.simFields.length];
                int i = 0;
                while (i < this.simFields.length) {
                    this.m_cdSysInfoChoice[i] = new ValueDescriptor(String.valueOf(i), this.simFields[i]);
                    ++i;
                }
            } else {
                Trace.trace(TRACE_MASKF, "simField not set.");
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 3, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- SysInfoManagerBean.load()");
    }

    public void update(Object bean) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.update(SysInfoManagerBean).");
        this.setValueEdit(((SysInfoManagerBean)bean).getValueEdit());
        if (this.userTaskManager != null) {
            this.userTaskManager.refreshElement("ValueEdit");
        } else {
            Trace.trace(TRACE_MASKD, "UserTaskManager not setup.");
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.update().");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.prepare().");
        this.userTaskManager.setNotifySelection(MENU, true);
        this.setSysInfoChoice(this.getSysInfoChoiceList()[0].getTitle());
        if (this.userTaskManager != null) {
            this.userTaskManager.refreshAllElements();
            SysInfoManagerBean bean = (SysInfoManagerBean)this.userTaskManager.getDataObjects()[0];
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", "LoadRun");
            request.setData("data", bean);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKD, "userTaskManager is null.");
        }
        this.userTaskManager.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)this, MENU);
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.prepare().");
    }

    protected void finalize() throws Throwable {
        Trace.trace(TRACE_MASKF, "--bean--in SIM finalize");
        super.finalize();
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.panelAction(TaskActionEvent).");
        String cmd = evt.getActionCommand();
        Trace.trace(TRACE_MASKD, "Command is " + cmd + ".");
        if (cmd.equals("CANCEL")) {
            Trace.trace(TRACE_MASKD, "Handler: Cancel button.");
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", cmd);
            this.postTaskletRequest(request);
        } else {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            if (utm == null) {
                Trace.trace(TRACE_MASKD, "evt.getSource returned null for UserTaskManager.");
            } else {
                utm.storeAllElements();
                SysInfoManagerBean bean = (SysInfoManagerBean)utm.getDataObjects()[0];
                if (cmd.equals("FindButton")) {
                    Trace.trace(TRACE_MASKD, "KeyEdit string = [" + this.getKeyEdit() + "].");
                    int[] id = new int[]{ItemDescUtils.anArray(this.simFields, this.getKeyEdit())};
                    Trace.trace(TRACE_MASKD, "simField index = " + id[0] + ".");
                    this.setSysInfoChoice(this.getSysInfoChoiceList()[id[0]].getTitle());
                    utm.refreshAllElements();
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("event", "EditItem");
                    request.setData("data", bean);
                    this.postTaskletRequest(request);
                } else if (cmd.equals("ApplyButton")) {
                    Trace.trace(TRACE_MASKD, "this.getValueEdit() = " + this.getValueEdit() + ".");
                    utm.refreshAllElements();
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("event", "ApplyButton");
                    request.setData("data", bean);
                    this.postTaskletRequest(request);
                } else if (cmd.equals("ResetButton")) {
                    this.resetValueEdit();
                    utm.refreshElement("ValueEdit");
                } else if (cmd.endsWith("EditItem")) {
                    int[] row = utm.getSelectedRows(MENU);
                    if (row != null && row.length > 0) {
                        Trace.trace(TRACE_MASKD, "row = " + row[0]);
                        Trace.trace(TRACE_MASKD, "getName [" + this.getSysInfoChoiceList()[row[0]].getName() + "].");
                        Trace.trace(TRACE_MASKD, "getTitle [" + this.getSysInfoChoiceList()[row[0]].getTitle() + "].");
                        this.setSysInfoChoice(this.getSysInfoChoiceList()[row[0]].getTitle());
                        utm.refreshAllElements();
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData("event", "EditItem");
                        request.setData("data", bean);
                        this.postTaskletRequest(request);
                    } else {
                        Trace.trace(TRACE_MASKD, "selected rows null of zero in length");
                    }
                } else {
                    Trace.trace(TRACE_MASKT, "I don't know this button: " + cmd + ".");
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.panelAction(TaskActionEvent).");
    }

    public void taskCompleted(TaskNotifyCompleteEvent evt) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.taskCompleted(TaskNotifyCompleteEvent).");
        UserTaskManager utm = (UserTaskManager)evt.getSource();
        int[] row = utm.getSelectedRows(MENU);
        if (row != null && row.length > 0) {
            Trace.trace(TRACE_MASKD, "row = " + row[0]);
            Trace.trace(TRACE_MASKD, "getName [" + this.getSysInfoChoiceList()[row[0]].getName() + "].");
            Trace.trace(TRACE_MASKD, "getTitle [" + this.getSysInfoChoiceList()[row[0]].getTitle() + "].");
            this.setSysInfoChoice(this.getSysInfoChoiceList()[row[0]].getTitle());
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", "EditItem");
            request.setData("data", this);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKD, "selected rows null of zero in length");
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.taskCompleted().");
    }
}

